'''This script reads in all the maperitive georef files
in a folder and converts them to GDAL-compatible world files
ex: image.tif.georef to image.tifw
'''

import os
import xml.etree.ElementTree as ET

#This is the folder that will get converted.
convert_dir = r"G:\Images"

def convert(path, file):
	doc = ET.parse(os.path.join(path, file)).getroot()
	origin = doc.find('origin')
	x = origin.find('x').text
	y = origin.find('y').text
	w = doc.find('cell-width').text
	h = doc.find('cell-height').text

	base = os.path.splitext(file)[0]
	outfile = os.path.join(path,base + 'w')
	
	with open(outfile, 'w') as F:
		F.write(w + "\n")
		F.write("0\n0\n")
		F.write(h + "\n")
		F.write(x + "\n")
		F.write(y + "\n")

refs = sorted([f for f in os.listdir(convert_dir) if f.endswith('.georef')])
for ref in refs:
	convert(convert_dir, ref)