'''
Fill in the terrain tile set with dummy files.
Each file will have 3601x3601 16-bit signed integers
'''

import os
import struct
import argparse

#Folder to read SRTM data in from, and output new SRTM files to
#They can be the same folder
in_folder = r"G:\SRTMGL1"
out_folder = r"G:\SRTMGL1_full"

def gen_raster(fillvalue=0, X=3601, Y=3601):
	#Create a blank hgt dataset, which is filled with 16-it zero values
	val = struct.pack(">h", fillvalue)
	raster = val*X*Y
	return raster

def gen_filename(NS, EW):
	#Create a standard SRTM filename based on an input lat/long
	fname = ""
	if NS < 0:
		fname += "S%02d"%(-NS)
	else:
		fname += "N%02d"%(NS)

	if EW < 0:
		fname += "W%03d"%(-EW)
	else:
		fname += "E%03d"%(EW)		

	fname += ".hgt"
	return fname

def run(args):
	#This is the range of NASA's SRTM dataset
	NSrange = range(-56,60)
	EWrange = range(-180,181)
		
	files = os.listdir(args.in_folder)
	files = [f for f in files if f.endswith(".hgt")]
	print "In Folder (%s): %d files"%(args.in_folder, len(files))

	outfiles = os.listdir(args.out_folder)
	outfiles = [f for f in outfiles if f.endswith(".hgt")]
	print "Out Folder (%s): %d files"%(args.out_folder, len(outfiles))

	if args.SRTMGL3:
		raster = gen_raster(X=1201, Y=1201)
	else:
		raster = gen_raster()	

	for NS in NSrange:
		for EW in EWrange:
			fname = gen_filename(NS,EW)
			if fname not in files and fname not in outfiles:
				print fname
				with open(os.path.join(args.out_folder, fname), 'w') as F:
					F.write(raster)

P = argparse.ArgumentParser(description="Fills in a set of SRTM hgt file data with missing tiles to create a complete set of world data")
P.add_argument("-s","--SRTMGL3", help="Use SRTMGL3 data (instead of SRTMGL1)", action='store_true')
P.add_argument("-i","--in_folder", default=in_folder,
	help="Folder to read SRTM data from. Default %s"%in_folder)
P.add_argument("-o","--out_folder", default=out_folder,
	help="Folder to write new SRTM data to. Default %s"%out_folder)

args = P.parse_args()
run(args)
