'''
Generates web tiles from a set of geo-reference images.
Intended to be used as a step following a run of gen_terrain_image_script.py
'''

import os
import argparse

images_dir = 'G:\\Images'
tiles_dir = 'G:\\TilesOut'
maperitive_path = "G:\\Maperitive\\"
script_file = "gen_image_tiles.mscript"

def gen(args):
    sfile = os.path.join(args.mdir, "Scripts", args.script)
    out = 'use-ruleset alias=default\nclear-map\n'

    files = os.listdir(args.idir)
    files = [f for f in files if f.lower().endswith(args.format.lower())]

    if len(files) == 0:
        print "No files found. Did you set the correct format with -f {png|tif|jpg}?"
    else:
        print "Found %d images to load."%(len(files))       

    for f in files:
        out += "load-source \"%s\"\n"%(os.path.join(args.idir, f))
    out += 'set-geo-bounds -180,-56,179.999999,60\n'
    out += 'generate-tiles minzoom=%d maxzoom=%d tilesdir=%s'%(args.minzoom, args.maxzoom, args.tdir)

    with open(sfile, "w") as F:
        F.write(out)

    print "Wrote script file:", sfile

def main(args):
    if not os.path.exists(args.tdir):
        os.mkdir(args.tdir)

    gen(args)

if __name__ == '__main__':
    P = argparse.ArgumentParser(
        description="Generates a maperitive script to load a folder of georeferenced images and create web tiles from them")
    P.add_argument("idir", default=images_dir, 
        help="Path of the input images. Default: %s"%images_dir)
    P.add_argument("tdir", default=tiles_dir, 
        help="Path of the output tiles. Default: %s"%tiles_dir)    
    P.add_argument("-f", "--format", choices=["png", "tif", "jpg"], default="png",
        help="Image format to write")
    P.add_argument("-n", "--minzoom", type=int, default=1,
        help="Minimum zoom level to generate (default 1)")
    P.add_argument("-x", "--maxzoom", type=int, default=7,
        help="Maximum zoom level to generate (default 7)")    
    P.add_argument("--mdir", default=maperitive_path, 
        help="Path to the Maperitive folder to write the script to. Default: %s"%maperitive_path)
    P.add_argument("--script", default=script_file, 
        help="File name of the script to generate. Default: %s"%script_file)
    args = P.parse_args()

    main(args)